import java.io.*;
import java.util.*;
import java.math.*;

public class A implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	private final String NORTH = "north";
	private final String WEST = "west";

	private String reverse(String s) {
		List<String> tokens = new ArrayList<>();
		while(!s.isEmpty()) {
			if(s.startsWith(NORTH)) {
				tokens.add(NORTH);
				s = s.substring(NORTH.length());
			} else {
				tokens.add(WEST);
				s = s.substring(WEST.length());
			}
		}
		Collections.reverse(tokens);
		String result = "";
		for(String t : tokens) {
			result += t;
		}
		return result;
	}
	
	private void solveOne(String s) {
		s = reverse(s);
		
		//out.println(s);
		
		long a = 0, b = 1;

		if (s.startsWith(NORTH)) {
			s = s.substring(NORTH.length());
		} else {
			a = 90;
			s = s.substring(WEST.length());
		}

		while (!s.isEmpty()) {
			if (s.startsWith(NORTH)) {
				s = s.substring(NORTH.length());
				a *= 2;
				b *= 2;
				a -= 90;
			} else {
				s = s.substring(WEST.length());
				a *= 2;
				b *= 2;
				a += 90;
			}
		}
		
		if(a < 0)
			a = -a;

		long g = gcd(a, b);

		a /= g;
		b /= g;

		if (b == 1) {
			out.println(a);
		} else {

			out.println(a + "/" + b);
		}
	}

	private long gcd(long a, long b) {
		return (b == 0 ? a : gcd(b, a % b));
	}

	private void solve() throws IOException {
		while (true) {
			String s = nextToken();
			if (s.equals("#"))
				break;
			solveOne(s);
		}
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new A().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
